# Buildah version 1.3 Release Announcement

![buildah logo](https://cdn.rawgit.com/containers/buildah/main/logos/buildah-logo_large.png)

We're pleased to announce the release of Buildah version 1.3 which is now available from GitHub for any Linux distro.  We are shipping this release on Fedora, RHEL 7, CentOS, openSUSE and Ubuntu in the near future.

The Buildah project has continued to grow over the past several weeks, welcoming several new contributors to the mix.  The highlights of this release are Dockerfile handling improvements, added the `buildah pull` command, added the `buildah rename` command, updated ulimits settings, added isolation control and several other enhancements and bug fixes.

## The major highlights for this release are:

* Dockerfiles with a ‘.in’ suffix are preprocessed during the build process.

CPP is now used by the ‘buildah bud’ command to preprocess any Dockerfile that has the ‘.in’ suffix.  This allows Dockerfiles to be decomposed and make them reusable via  CPP’s #include directive. Notice that those Dockerfiles can still be used by other tools by manually running cpp -E on them.  Stay tuned for an upcoming blog with an example.  (Many thanks to Valentin Rothberg for providing this functionality.)

* Dockerfile input can come from stdin.

If you use a dash ‘-’ as the argument to the `buildah bud --file` parameter, Dockerfile contents will be read from stdin.

* Created a pull and rename command.

The new `buildah pull` command pulls an image without creating a container like the `buildah from` command does.  The new `buildah rename` command renames a container.

* Ulimits settings now match the settings we add to the Docker unit file.

The maximum number of processes and the number of open files that Buildah will handle now match the same number that Docker handles.

* Added the ability to select the type of isolation to be used.

By setting the new BUILDAH_ISOLATION environment variable or by using the new --isolation parameter found in the bud, from and run commands, one can select the type of isolation to use for running processes as part of the RUN instruction.  Recognized types include oci, rootless and chroot.  For more details, please refer to the `buildah bud`, `buildah from` and `buildah run` man pages.  These new isolations are being added to run buildah inside locked down containers.

## Release Changes
* preprocess ".in" suffixed Dockerfiles.
* Allow Dockerfile content to come from stdin.
* Create buildah pull command.
* Create buildah rename command.
* Set the default ulimits to match Docker.
* Set BUILDAH_ISOLATION=rootless when running unprivileged.
* Add and implement IsolationOCIRootless.
* Add a value for IsolationOCIRootless.
* Fix rmi to remove intermediate images associated with an image.
* Switch to github.com/containers/image/pkg/sysregistriesv2.
* unshare: error message missed the pid.
* bud should not search just the context directory for Dockerfile.
* Add support for multiple Short options.
* Fixed volume cache issue with buildah bud --layers.
* Allow ping command without NET_RAW Capabilities.
* usernamespace: assign additional IDs sequentially.
* Remove default dev/pts which allows Buildah to be run as non-root.
 * Documentation changes:
   * Fix the the in buildah-config man page.
* Updated the following packages to newer versions:  containers/image, containers/storage, runc, and urfave/cli.
* Plus a number of smaller fixes.

## Try it Out.

If you haven’t yet, install Buildah from the Fedora repo or GitHub and give it a spin.  We’re betting you'll find it’s an easy and quick way to build containers in your environment without a daemon being involved!

For those of you who contributed to this release, thank you very much for your contributions!  If you haven't joined our community yet, don't wait any longer!  Come join us in GitHub, where Open Source communities live.

## Buildah == Simplicity
