# Source Map

This is a library to generate and consume the source map format
[described here][format].

[Learn more here][feature].

This library was written in the Asynchronous Module Definition
format. It should work in the following environments:

* Modern Browsers (either after the build, or with an AMD loader such as
  RequireJS)

* Inside Firefox (as a JSM file, after the build)

* With NodeJS versions 0.8.X and higher

## Installing with NPM (for use with NodeJS)

Simply

    $ npm install source-map

Or, if you'd like to hack on this library and have it installed via npm so you
can try out your changes:

    $ git clone https://fitzgen@github.com/mozilla/source-map.git
    $ cd source-map
    $ npm link .

## Building from Source (for everywhere else)

Install Node and then run

    $ git clone https://fitzgen@github.com/mozilla/source-map.git
    $ cd source-map
    $ npm link .

Next, run

    $ node Makefile.dryice.js`

This should create the following files:

* `dist/source-map.js` - The unminified browser version.

* `dist/source-map.min.js` - The minified browser version.

* `dist/SourceMap.jsm` - The JavaScript Module for inclusion in Firefox
  source.

## API

Get a reference to the module:

    // NodeJS
    var sourceMap = require('source-map');

    // Browser builds
    var sourceMap = window.sourceMap;

    // Inside Firefox
    let sourceMap = {};
    Components.utils.import('resource:///modules/devtools/SourceMap.jsm', sourceMap);

### SourceMapConsumer

A SourceMapConsumer instance represents a parsed source map which we can query
for information about the original file positions by giving it a file position
in the generated source.

#### new SourceMapConsumer(rawSourceMap)

The only parameter is the raw source map (either as a string which can be
`JSON.parse`'d, or an object). According to the spec, source maps have the
following attributes:

* `version`: Which version of the source map spec this map is following.

* `sources`: An array of URLs to the original source files.

* `names`: An array of identifiers which can be referrenced by individual
  mappings.

* `sourceRoot`: Optional. The URL root from which all sources are relative.

* `sourcesContent`: Optional. An array of contents of the original source files.

* `mappings`: A string of base64 VLQs which contain the actual mappings.

* `file`: The generated filename this source map is associated with.

#### SourceMapConsumer.prototype.originalPositionFor(generatedPosition)

Returns the original source, line, and column information for the generated
source's line and column positions provided. The only argument is an object with
the following properties:

* `line`: The line number in the generated source.

* `column`: The column number in the generated source.

and an object is returned with the following properties:

* `source`: The original source file, or null if this information is not
  available.

* `line`: The line number in the original source, or null if this information is
  not available.

* `column`: The column number in the original source, or null or null if this
  information is not available.

* `name`: The original identifier, or null if this information is not available.

#### SourceMapConsumer.prototype.generatedPositionFor(originalPosition)

Returns the generated line and column information for the original source,
line, and column positions provided. The only argument is an object with
the following properties:

* `source`: The filename of the original source.

* `line`: The line number in the original source.

* `column`: The column number in the original source.

and an object is returned with the following properties:

* `line`: The line number in the generated source, or null.

* `column`: The column number in the generated source, or null.

#### SourceMapConsumer.prototype.sourceContentFor(source)

Returns the original source content for the source provided. The only
argument is the URL of the original source file.

#### SourceMapConsumer.prototype.eachMapping(callback, context, order)

Iterate over each mapping between an original source/line/column and a
generated line/column in this source map.

* `callback`: The function that is called with each mapping.

* `context`: Optional. If specified, this object will be the value of `this`
  every time that `callback` is called.

* `order`: Either `SourceMapConsumer.GENERATED_ORDER` or
  `SourceMapConsumer.ORIGINAL_ORDER`. Specifies whether you want to iterate over
  the mappings sorted by the generated file's line/column order or the
  original's source/line/column order, respectively. Defaults to
  `SourceMapConsumer.GENERATED_ORDER`.

### SourceMapGenerator

An instance of the SourceMapGenerator represents a source map which is being
built incrementally.

#### new SourceMapGenerator(startOfSourceMap)

To create a new one, you must pass an object with the following properties:

* `file`: The filename of the generated source that this source map is
  associated with.

* `sourceRoot`: An optional root for all relative URLs in this source map.

#### SourceMapGenerator.fromSourceMap(sourceMapConsumer)

Creates a new SourceMapGenerator based on a SourceMapConsumer

* `sourceMapConsumer` The SourceMap.

#### SourceMapGenerator.prototype.addMapping(mapping)

Add a single mapping from original source line and column to the generated
source's line and column for this source map being created. The mapping object
should have the following properties:

* `generated`: An object with the generated line and column positions.

* `original`: An object with the original line and column positions.

* `source`: The original source file (relative to the sourceRoot).

* `name`: An optional original token name for this mapping.

#### SourceMapGenerator.prototype.setSourceContent(sourceFile, sourceContent)

Set the source content for an original source file.

* `sourceFile` the URL of the original source file.

* `sourceContent` the content of the source file.

#### SourceMapGenerator.prototype.applySourceMap(sourceMapConsumer[, sourceFile])

Applies a SourceMap for a source file to the SourceMap.
Each mapping to the supplied source file is rewritten using the
supplied SourceMap. Note: The resolution for the resulting mappings
is the minimium of this map and the supplied map.

* `sourceMapConsumer`: The SourceMap to be applied.

* `sourceFile`: Optional. The filename of the source file.
  If omitted, sourceMapConsumer.file will be used.

#### SourceMapGenerator.prototype.toString()

Renders the source map being generated to a string.

### SourceNode

SourceNodes provide a way to abstract over interpolating and/or concatenating
snippets of generated JavaScript source code, while maintaining the line and
column information associated between those snippets and the original source
code. This is useful as the final intermediate representation a compiler might
use before outputting the generated JS and source map.

#### new SourceNode(line, column, source[, chunk[, name]])

* `line`: The original line number associated with this source node, or null if
  it isn't associated with an original line.

* `column`: The original column number associated with this source node, or null
  if it isn't associated with an original column.

* `source`: The original source's filename.

* `chunk`: Optional. Is immediately passed to `SourceNode.prototype.add`, see
  below.

* `name`: Optional. The original identifier.

#### SourceNode.fromStringWithSourceMap(code, sourceMapConsumer)

Creates a SourceNode from generated code and a SourceMapConsumer.

* `code`: The generated code

* `sourceMapConsumer` The SourceMap for the generated code

#### SourceNode.prototype.add(chunk)

Add a chunk of generated JS to this source node.

* `chunk`: A string snippet of generated JS code, another instance of
   `SourceNode`, or an array where each member is one of those things.

#### SourceNode.prototype.prepend(chunk)

Prepend a chunk of generated JS to this source node.

* `chunk`: A string snippet of generated JS code, another instance of
   `SourceNode`, or an array where each member is one of those things.

#### SourceNode.prototype.setSourceContent(sourceFile, sourceContent)

Set the source content for a source file. This will be added to the
`SourceMap` in the `sourcesContent` field.

* `sourceFile`: The filename of the source file

* `sourceContent`: The content of the source file

#### SourceNode.prototype.walk(fn)

Walk over the tree of JS snippets in this node and its children. The walking
function is called once for each snippet of JS and is passed that snippet and
the its original associated source's line/column location.

* `fn`: The traversal function.

#### SourceNode.prototype.walkSourceContents(fn)

Walk over the tree of SourceNodes. The walking function is called for each
source file content and is passed the filename and source content.

* `fn`: The traversal function.

#### SourceNode.prototype.join(sep)

Like `Array.prototype.join` except for SourceNodes. Inserts the separator
between each of this source node's children.

* `sep`: The separator.

#### SourceNode.prototype.replaceRight(pattern, replacement)

Call `String.prototype.replace` on the very right-most source snippet. Useful
for trimming whitespace from the end of a source node, etc.

* `pattern`: The pattern to replace.

* `replacement`: The thing to replace the pattern with.

#### SourceNode.prototype.toString()

Return the string representation of this source node. Walks over the tree and
concatenates all the various snippets together to one string.

### SourceNode.prototype.toStringWithSourceMap(startOfSourceMap)

Returns the string representation of this tree of source nodes, plus a
SourceMapGenerator which contains all the mappings between the generated and
original sources.

The arguments are the same as those to `new SourceMapGenerator`.

## Tests

[![Build Status](https://travis-ci.org/mozilla/source-map.png?branch=master)](https://travis-ci.org/mozilla/source-map)

Install NodeJS version 0.8.0 or greater, then run `node test/run-tests.js`.

To add new tests, create a new file named `test/test-<your new test name>.js`
and export your test functions with names that start with "test", for example

    exports["test doing the foo bar"] = function (assert, util) {
      ...
    };

The new test will be located automatically when you run the suite.

The `util` argument is the test utility module located at `test/source-map/util`.

The `assert` argument is a cut down version of node's assert module. You have
access to the following assertion functions:

* `doesNotThrow`

* `equal`

* `ok`

* `strictEqual`

* `throws`

(The reason for the restricted set of test functions is because we need the
tests to run inside Firefox's test suite as well and so the assert module is
shimmed in that environment. See `build/assert-shim.js`.)

[format]: https://docs.google.com/document/d/1U1RGAehQwRypUTovF1KRlpiOFze0b-_2gc6fAH0KY0k/edit
[feature]: https://wiki.mozilla.org/DevTools/Features/SourceMap
[Dryice]: https://github.com/mozilla/dryice
