<?php declare(strict_types=1);
/*
 * This file is part of PHPUnit.
 *
 * (c) Sebastian Bergmann <sebastian@phpunit.de>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
namespace PHPUnit\Logging\OpenTestReporting;

/**
 * @no-named-arguments Parameter names are not covered by the backward compatibility promise for PHPUnit
 *
 * @internal This enumeration is not covered by the backward compatibility promise for PHPUnit
 */
enum Status: string
{
    case Aborted    = 'ABORTED';
    case Errored    = 'ERRORED';
    case Failed     = 'FAILED';
    case Skipped    = 'SKIPPED';
    case Successful = 'SUCCESSFUL';
}
