# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, TYPE_CHECKING

from azure.core.rest import HttpRequest, HttpResponse
from azure.mgmt.core import ARMPipelineClient

from . import models as _models
from .._serialization import Deserializer, Serializer
from ._configuration import AuthorizationManagementClientConfiguration
from .operations import (
    Operations,
    RoleAssignmentApprovalOperations,
    RoleAssignmentApprovalStepOperations,
    RoleAssignmentApprovalStepsOperations,
    ScopeRoleAssignmentApprovalOperations,
    ScopeRoleAssignmentApprovalStepOperations,
    ScopeRoleAssignmentApprovalStepsOperations,
)

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials import TokenCredential


class AuthorizationManagementClient:  # pylint: disable=client-accepts-api-version-keyword,too-many-instance-attributes
    """Request Approvals service provides the workflow for running request approvals on different kind
    of resources.

    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.authorization.v2021_01_01_preview.operations.Operations
    :ivar role_assignment_approval: RoleAssignmentApprovalOperations operations
    :vartype role_assignment_approval:
     azure.mgmt.authorization.v2021_01_01_preview.operations.RoleAssignmentApprovalOperations
    :ivar role_assignment_approval_steps: RoleAssignmentApprovalStepsOperations operations
    :vartype role_assignment_approval_steps:
     azure.mgmt.authorization.v2021_01_01_preview.operations.RoleAssignmentApprovalStepsOperations
    :ivar role_assignment_approval_step: RoleAssignmentApprovalStepOperations operations
    :vartype role_assignment_approval_step:
     azure.mgmt.authorization.v2021_01_01_preview.operations.RoleAssignmentApprovalStepOperations
    :ivar scope_role_assignment_approval: ScopeRoleAssignmentApprovalOperations operations
    :vartype scope_role_assignment_approval:
     azure.mgmt.authorization.v2021_01_01_preview.operations.ScopeRoleAssignmentApprovalOperations
    :ivar scope_role_assignment_approval_steps: ScopeRoleAssignmentApprovalStepsOperations
     operations
    :vartype scope_role_assignment_approval_steps:
     azure.mgmt.authorization.v2021_01_01_preview.operations.ScopeRoleAssignmentApprovalStepsOperations
    :ivar scope_role_assignment_approval_step: ScopeRoleAssignmentApprovalStepOperations operations
    :vartype scope_role_assignment_approval_step:
     azure.mgmt.authorization.v2021_01_01_preview.operations.ScopeRoleAssignmentApprovalStepOperations
    :param credential: Credential needed for the client to connect to Azure. Required.
    :type credential: ~azure.core.credentials.TokenCredential
    :param base_url: Service URL. Default value is "https://management.azure.com".
    :type base_url: str
    :keyword api_version: Api Version. Default value is "2021-01-01-preview". Note that overriding
     this default value may result in unsupported behavior.
    :paramtype api_version: str
    """

    def __init__(
        self, credential: "TokenCredential", base_url: str = "https://management.azure.com", **kwargs: Any
    ) -> None:
        self._config = AuthorizationManagementClientConfiguration(credential=credential, **kwargs)
        self._client: ARMPipelineClient = ARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in _models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.operations = Operations(
            self._client, self._config, self._serialize, self._deserialize, "2021-01-01-preview"
        )
        self.role_assignment_approval = RoleAssignmentApprovalOperations(
            self._client, self._config, self._serialize, self._deserialize, "2021-01-01-preview"
        )
        self.role_assignment_approval_steps = RoleAssignmentApprovalStepsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2021-01-01-preview"
        )
        self.role_assignment_approval_step = RoleAssignmentApprovalStepOperations(
            self._client, self._config, self._serialize, self._deserialize, "2021-01-01-preview"
        )
        self.scope_role_assignment_approval = ScopeRoleAssignmentApprovalOperations(
            self._client, self._config, self._serialize, self._deserialize, "2021-01-01-preview"
        )
        self.scope_role_assignment_approval_steps = ScopeRoleAssignmentApprovalStepsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2021-01-01-preview"
        )
        self.scope_role_assignment_approval_step = ScopeRoleAssignmentApprovalStepOperations(
            self._client, self._config, self._serialize, self._deserialize, "2021-01-01-preview"
        )

    def _send_request(self, request: HttpRequest, **kwargs: Any) -> HttpResponse:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = client._send_request(request)
        <HttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/dpcodegen/python/send_request

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.HttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, **kwargs)

    def close(self) -> None:
        self._client.close()

    def __enter__(self) -> "AuthorizationManagementClient":
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details: Any) -> None:
        self._client.__exit__(*exc_details)
