# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.apimanagement.aio import ApiManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestApiManagementIdentityProviderOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ApiManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_identity_provider_list_by_service(self, resource_group):
        response = self.client.identity_provider.list_by_service(
            resource_group_name=resource_group.name,
            service_name="str",
            api_version="2024-05-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_identity_provider_get_entity_tag(self, resource_group):
        response = await self.client.identity_provider.get_entity_tag(
            resource_group_name=resource_group.name,
            service_name="str",
            identity_provider_name="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_identity_provider_get(self, resource_group):
        response = await self.client.identity_provider.get(
            resource_group_name=resource_group.name,
            service_name="str",
            identity_provider_name="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_identity_provider_create_or_update(self, resource_group):
        response = await self.client.identity_provider.create_or_update(
            resource_group_name=resource_group.name,
            service_name="str",
            identity_provider_name="str",
            parameters={
                "allowedTenants": ["str"],
                "authority": "str",
                "clientId": "str",
                "clientLibrary": "str",
                "clientSecret": "str",
                "id": "str",
                "name": "str",
                "passwordResetPolicyName": "str",
                "profileEditingPolicyName": "str",
                "signinPolicyName": "str",
                "signinTenant": "str",
                "signupPolicyName": "str",
                "type": "str",
            },
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_identity_provider_update(self, resource_group):
        response = await self.client.identity_provider.update(
            resource_group_name=resource_group.name,
            service_name="str",
            identity_provider_name="str",
            if_match="str",
            parameters={
                "allowedTenants": ["str"],
                "authority": "str",
                "clientId": "str",
                "clientLibrary": "str",
                "clientSecret": "str",
                "passwordResetPolicyName": "str",
                "profileEditingPolicyName": "str",
                "signinPolicyName": "str",
                "signinTenant": "str",
                "signupPolicyName": "str",
                "type": "str",
            },
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_identity_provider_delete(self, resource_group):
        response = await self.client.identity_provider.delete(
            resource_group_name=resource_group.name,
            service_name="str",
            identity_provider_name="str",
            if_match="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_identity_provider_list_secrets(self, resource_group):
        response = await self.client.identity_provider.list_secrets(
            resource_group_name=resource_group.name,
            service_name="str",
            identity_provider_name="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...
