% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{getUniques}
\alias{getUniques}
\title{Get the uniques-vector from the input object.}
\usage{
getUniques(object, collapse = TRUE, silence = FALSE)
}
\arguments{
\item{object}{(Required). The object from which to extract the \code{\link{uniques-vector}}.}

\item{collapse}{(Optional). Default TRUE.
Should duplicate sequences detected in \code{object} be collapsed together, thereby
 imposing uniqueness on non-unique input.}

\item{silence}{(Optional). Default FALSE.
Suppress reporting of the detection and merger of duplicated input sequences.}
}
\value{
\code{integer}.
 An integer vector named by unique sequence and valued by abundance.
}
\description{
This function extracts the \code{\link{uniques-vector}} from several different data objects, 
 including \code{\link{dada-class}} and \code{\link{derep-class}} objects, as well as 
 \code{data.frame} objects that have both $sequence and $abundance columns.
 The return value is an integer vector named by sequence and valued by abundance. If the input is
 already in \code{\link{uniques-vector}} format, that same vector will be returned.
}
\examples{
derep1 = derepFastq(system.file("extdata", "sam1F.fastq.gz", package="dada2"))
dada1 <- dada(derep1, err=tperr1)
getUniques(derep1)[1:3]
getUniques(dada1)[1:3]
getUniques(dada1$clustering)[1:3]

}
