% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/results.R
\name{degComps}
\alias{degComps}
\title{Automatize the use of \code{results()} for multiple comparisons}
\usage{
degComps(
  dds,
  combs = NULL,
  contrast = NULL,
  alpha = 0.05,
  skip = FALSE,
  type = "normal",
  pairs = FALSE,
  fdr = "default"
)
}
\arguments{
\item{dds}{\link[DESeq2:DESeqDataSet]{DESeq2::DESeqDataSet} obcject.}

\item{combs}{Optional vector indicating the coefficients or columns
fom \code{colData(dds)} to create group comparisons.}

\item{contrast}{Optional vector to specify contrast. See \code{\link[DESeq2:results]{DESeq2::results()}}.}

\item{alpha}{Numeric value used in independent filtering in \code{\link[DESeq2:results]{DESeq2::results()}}.}

\item{skip}{Boolean to indicate whether skip shrinkage. For instance
when it comes from LRT method.}

\item{type}{Type of shrinkage estimator. See \code{\link[DESeq2:lfcShrink]{DESeq2::lfcShrink()}}.}

\item{pairs}{Boolean to indicate whether create all comparisons or only
use the coefficient already created from \code{DESeq2::resultsNames()}.}

\item{fdr}{type of fdr correction. \code{default} is FDR value,
\code{lfdr-stat} is
for local FDR using the statistics of the test,
\code{lfdr-pvalue} is for local FDR using the p-value of the test. fdrtools
needs to be installed and loaded by the user}
}
\value{
\link{DEGSet} with unSrunken and Srunken results.
}
\description{
This function will extract the output of \code{\link[DESeq2:results]{DESeq2::results()}}
and \code{\link[DESeq2:lfcShrink]{DESeq2::lfcShrink()}} for multiple comparison using:
}
\details{
\itemize{
\item coefficients
\item contrast
\item Multiple columns in \code{colData} that match coefficients
\item Multiple columns in \code{colData} to create all possible
contrasts
}
}
\examples{
library(DESeq2)
dds <- makeExampleDESeqDataSet(betaSD=1)
colData(dds)[["treatment"]] <- sample(colData(dds)[["condition"]], 12)
  design(dds) <-  ~ condition + treatment
dds <- DESeq(dds)
res <- degComps(dds, combs = c("condition", 2),
                contrast = list("treatment_B_vs_A", c("condition", "A", "B")))
# library(fdrtools)
#res <- degComps(dds,contrast = list("treatment_B_vs_A"),
#                fdr="lfdr-stat")
}
\author{
Lorena Pantano
}
