% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StackedTrack-class.R
\docType{class}
\name{StackedTrack-class}
\alias{StackedTrack-class}
\alias{initialize,StackedTrack-method}
\alias{stacking,StackedTrack-method}
\alias{stacking<-,StackedTrack,character-method}
\alias{stacks,StackedTrack-method}
\alias{setStacks,StackedTrack-method}
\alias{consolidateTrack,StackedTrack-method}
\alias{[,StackedTrack,ANY,ANY,ANY-method}
\alias{subset,StackedTrack-method}
\alias{drawGD,StackedTrack-method}
\title{StackedTrack class and methods}
\usage{
\S4method{initialize}{StackedTrack}(.Object, stacking, ...)

\S4method{stacking}{StackedTrack}(GdObject)

\S4method{stacking}{StackedTrack,character}(GdObject) <- value

\S4method{stacks}{StackedTrack}(GdObject)

\S4method{setStacks}{StackedTrack}(GdObject, ...)

\S4method{consolidateTrack}{StackedTrack}(GdObject, ...)

\S4method{[}{StackedTrack,ANY,ANY,ANY}(x, i, j, ..., drop = TRUE)

\S4method{subset}{StackedTrack}(x, from = NULL, to = NULL, sort = FALSE, stacks = FALSE, ...)

\S4method{drawGD}{StackedTrack}(GdObject, ...)
}
\arguments{
\item{.Object}{.Object}

\item{stacking}{stacking}

\item{...}{Additional arguments.}

\item{GdObject}{Object of \code{GdObject-class}.}

\item{value}{Value to be set.}

\item{x}{A valid track object class name, or the object itself, in which
case the class is derived directly from it.}

\item{i}{Numeric scalar, index to subset.}

\item{j}{Numeric scalar, index to subset. Ignored.}

\item{drop}{\code{logical}, indicating if levels that do not occur should be dropped (if \code{f} is a factor).}

\item{from, to}{Numeric scalar, giving the range of genomic coordinates to
limit the tracks in. Note that \code{to} cannot be larger than \code{from.}}

\item{sort}{\code{logical}.}

\item{stacks}{\code{logical}. Set if stacking should  be preserved.}
}
\value{
A virtual Class: No objects may be created from it.
}
\description{
The virtual parent class for all track types in the Gviz package which
contain potentially overlapping annotation items that have to be stacked
when plotted.
}
\section{Functions}{
\itemize{
\item \code{initialize(StackedTrack)}: Initialize.

\item \code{stacking(StackedTrack)}: return the current stacking type.

\item \code{stacking(GdObject = StackedTrack) <- value}: set the object's stacking type to one in
\code{c(hide, dense, squish, pack,full)}.

\item \code{stacks(StackedTrack)}: return the stack indices for each track item.

\item \code{setStacks(StackedTrack)}: recompute the stacks based on the available
space and on the object's track items and stacking settings.

\item \code{consolidateTrack(StackedTrack)}: Consolidate.
a display parameter)

\item \code{x[i}: subset the items in the \code{StackedTrack} object.
This is essentially similar to subsetting of the \code{GRanges} object in the
range slot. For most applications, the subset method may be more appropriate.

\item \code{subset(StackedTrack)}: subset a \code{StackedTrack} by coordinates and sort if necessary.

\item \code{drawGD(StackedTrack)}: plot the object to a graphics device.
The return value of this method is the input object, potentially updated
during the plotting operation. Internally, there are two modes in which
the method can be called. Either in 'prepare' mode, in which case no
plotting is done but the stacking information is updated based on the
available space, or in 'plotting' mode, in which case the actual graphical
output is created. Note that the method for this particular subclass is
usually called through inheritance and not particularly useful on its own.

}}
\section{Slots}{

\describe{
\item{\code{dp}}{Object of \code{DisplayPars-class}, the display settings controlling the
look and feel of a track. See settings for details on setting graphical
parameters for tracks.}

\item{\code{name}}{Object of class \code{character}, a human-readable name for the track
that will be used in the track's annotation panel if necessary.}

\item{\code{imageMap}}{Object of \code{ImageMap-class}, containing optional information
for an HTML image map. This will be created by the \code{drawGD} methods when the
track is plotted to a device and is usually not set by the user.}

\item{\code{range}}{Object of class \code{GRanges}, the genomic ranges of the track items
as well as additional annotation information in its \code{elementMetaData} slot.
Please not that the slot is actually implemented as a class union between
\code{GRanges} and IRanges to increase efficiency, for instance for DataTrack
objects. This usually does not concern the user.}

\item{\code{chromosome}}{Object of class \code{character}, the chromosome on which the
track is defined. There can only be a single chromosome for one track. For
certain subclasses, the space of allowed chromosome names is limited (e.g.,
only those chromosomes that exist for a particular genome). Throughout the
package, chromosome name have to be entered either as a single integer scalar
or as a character scalar of the form chrXYZ, where XYZ may be an arbitrary
character string.}

\item{\code{genome}}{Object of class \code{character}, the genome for which the track is
defined. For most sub-classes this has to be valid UCSC genome identifier,
however this may not always be formally checked upon object instantiation.}

\item{\code{stacking}}{Object of class \code{character}, the stacking type of overlapping
items on the final plot. One in \code{c(hide, dense, squish, pack,full)}.
Currently, only \code{hide} (do not show the track items at all), \code{squish} (make
best use of the available space) and \code{dense} (no stacking at all) are
implemented.}

\item{\code{stacks}}{Object of class \code{numeric}, holding the stack indices for each
track item. This slot is usually populated by calling the \code{setStacks} method
upon plotting, since the correct stacking is a function of the available
plotting space.}
}}

\examples{
## This is a reference class therefore we show below
## an example from AnnotationTrack

## An empty object
AnnotationTrack()

## Construct from individual arguments
st <- c(2000000, 2070000, 2100000, 2160000)
ed <- c(2050000, 2130000, 2150000, 2170000)
str <- c("-", "+", "-", "-")
gr <- c("Group1", "Group2", "Group1", "Group3")

annTrack <- AnnotationTrack(
    start = st, end = ed, strand = str, chromosome = 7,
    genome = "hg19", feature = "test", group = gr,
    id = paste("annTrack item", 1:4),
    name = "generic annotation", stacking = "squish"
)
\dontshow{
## For some annoying reason the postscript device does not know about
## the sans font
if (!interactive()) {
    font <- ps.options()$family
    displayPars(annTrack) <- list(fontfamily = font, fontfamily.title = font)
}
}

## Plotting
plotTracks(annTrack)

## Stacking
stacking(annTrack)
stacking(annTrack) <- "dense"
plotTracks(annTrack)
}
\seealso{
\code{\linkS4class{DisplayPars}}

\code{\linkS4class{GdObject}}

\code{\linkS4class{GRanges}}

\code{\linkS4class{HighlightTrack}}

\code{\linkS4class{ImageMap}}

\code{\linkS4class{IRanges}}

\code{\linkS4class{RangeTrack}}

\code{\linkS4class{DataTrack}}

\code{\link{collapsing}}

\code{\link{grouping}}

\code{\link{panel.grid}}

\code{\link{plotTracks}}

\code{\link{settings}}
}
\author{
Florian Hahne
}
