% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetchMetadataDatabase.R
\name{fetchMetadataDatabase}
\alias{fetchMetadataDatabase}
\title{Fetch a metadata database}
\usage{
fetchMetadataDatabase(
  name = "bioconductor.sqlite3",
  cache = cacheDirectory(),
  overwrite = FALSE
)
}
\arguments{
\item{name}{String containing the name of the database.
This can be the name of any SQLite file in \url{https://github.com/ArtifactDB/bioconductor-metadata-index/releases/tag/latest}.}

\item{cache}{String containing the cache directory.
If \code{NULL}, no caching is performed.}

\item{overwrite}{Logical scalar indicating whether to overwrite an existing file in \code{cache}, if one is present.}
}
\value{
String containing a path to the downloaded database.
}
\description{
Fetch a SQLite database containing metadata from the gypsum backend
(see \url{https://github.com/ArtifactDB/bioconductor-metadata-index}).
Each database is generated by aggregating metadata across multiple assets and/or projects,
and can be used to perform searches for interesting objects.
}
\details{
This function will automatically check for updates to the SQLite files and will download new versions accordingly.
New checks are performed when one hour or more has elapsed since the last check.
If the check fails, a warning is raised and the function returns the currently cached file.
}
\examples{
fetchMetadataDatabase()
}
\seealso{
\code{\link{fetchMetadataSchema}}, to get the JSON schema used to define the database tables.
}
\author{
Aaron Lun
}
