% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uploadDirectory.R
\name{uploadDirectory}
\alias{uploadDirectory}
\title{Upload a directory to the gypsum backend}
\usage{
uploadDirectory(
  directory,
  project,
  asset,
  version,
  cache = cacheDirectory(),
  deduplicate = TRUE,
  probation = FALSE,
  url = restUrl(),
  token = accessToken(),
  concurrent = 1,
  abort.failed = TRUE
)
}
\arguments{
\item{directory}{String containing the path to a directory to be uploaded.}

\item{project}{String containing the project name.}

\item{asset}{String containing the asset name.
This should not contain \code{/} or start with \code{..}.}

\item{version}{String containing the version name.
This should not contain \code{/} or start with \code{..}.}

\item{cache}{String containing the path to the cache for saving files, e.g., in \code{\link{saveVersion}}.
Used to convert symbolic links to upload links, see \code{\link{prepareDirectoryUpload}}.}

\item{deduplicate}{Logical scalar indicating whether the backend should attempt deduplication of \code{files} in the immediately previous version.
Only has an effect if \code{files} is not a data frame or if the \code{dedup} field is missing.}

\item{probation}{Logical scalar indicating whether to perform a probational upload.
Such uploads must be approved by the project owner before they are considered official.}

\item{url}{String containing the URL of the gypsum REST API.}

\item{token}{String containing a GitHub access token to authenticate to the gypsum REST API.
The token must refer to a user that is authorized to upload to the specified \code{project}.}

\item{concurrent}{Integer scalar specifying the number of concurrent uploads in \code{\link{uploadFiles}}.}

\item{abort.failed}{Logical scalar indicating whether to abort the upload on any failure.
Setting this to \code{FALSE} can be helpful for diagnosing upload problems.}
}
\value{
On successful upload, \code{NULL} is invisibly returned.
}
\description{
Convenience method to upload a directory to the gypsum backend as a versioned asset of a project.
This requires uploader permissions to the relevant project.
}
\details{
This function is a wrapper around \code{\link{prepareDirectoryUpload}} and \code{\link{startUpload}} and friends.
The aim is to streamline the upload of a directory's contents when no customization of the file listing is required.
}
\examples{
tmp <- tempfile()
dir.create(tmp)
write(file=file.path(tmp, "blah.txt"), LETTERS)
dir.create(file.path(tmp, "foo"))
write(file=file.path(tmp, "foo", "bar.txt"), 1:10)

if (interactive()) {
    # Uploading a probational version for test purposes.
    uploadDirectory(staging, "test-R", "upload-dir-check", version, probation=TRUE)

    # Cleaning up after ourselves.
    gypsum::rejectProbation("test-R", "upload-dir-check", version)
}

}
\author{
Aaron Lun
}
