% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateMappingBiasVcf.R
\name{calculateMappingBiasVcf}
\alias{calculateMappingBiasVcf}
\title{Calculate Mapping Bias}
\usage{
calculateMappingBiasVcf(
  normal.panel.vcf.file,
  min.normals = 1,
  min.normals.betafit = 7,
  min.median.coverage.betafit = 5,
  yieldSize = 5000,
  genome
)
}
\arguments{
\item{normal.panel.vcf.file}{Combined VCF file of a panel of normals,
reference and alt counts as AD genotype field. Should be compressed and
indexed with bgzip and tabix, respectively.}

\item{min.normals}{Minimum number of normals with heterozygous SNP for
calculating position-specific mapping bias.}

\item{min.normals.betafit}{Minimum number of normals with heterozygous SNP
fitting a beta distribution}

\item{min.median.coverage.betafit}{Minimum median coverage of normals with
heterozygous SNP for fitting a beta distribution}

\item{yieldSize}{See \code{TabixFile}}

\item{genome}{See \code{readVcf}}
}
\value{
A \code{GRanges} object with mapping bias and number of normal
samples with this variant.
}
\description{
Function calculate mapping bias for each variant in the provided
panel of normals VCF.
}
\examples{

normal.panel.vcf <- system.file("extdata", "normalpanel.vcf.gz", package="PureCN")
bias <- calculateMappingBiasVcf(normal.panel.vcf, genome = "h19")
saveRDS(bias, "mapping_bias.rds")

}
\author{
Markus Riester
}
