% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Filter.R, R/FilterEnsemble.R
\name{makeFilter}
\alias{makeFilter}
\title{Create a feature filter.}
\usage{
makeFilter(name, desc, pkg, supported.tasks, supported.features, fun)
}
\arguments{
\item{name}{(\code{character(1)})\cr
Identifier for the filter.}

\item{desc}{(\code{character(1)})\cr
Short description of the filter.}

\item{pkg}{(\code{character(1)})\cr
Source package where the filter is implemented.}

\item{supported.tasks}{(\link{character})\cr
Task types supported.}

\item{supported.features}{(\link{character})\cr
Feature types supported.}

\item{fun}{(\verb{function(task, nselect, ...})\cr
Function which takes a task and returns a named numeric vector of scores,
one score for each feature of \code{task}.
Higher scores mean higher importance of the feature.
At least \code{nselect} features must be calculated, the remaining may be
set to \code{NA} or omitted, and thus will not be selected.
the original order will be restored if necessary.}
}
\value{
Object of class \dQuote{Filter}.
}
\description{
Creates and registers custom feature filters. Implemented filters
can be listed with \link{listFilterMethods}. Additional
documentation for the \code{fun} parameter specific to each filter can
be found in the description.
}
\references{
Kira, Kenji and Rendell, Larry (1992). The Feature Selection Problem: Traditional
Methods and a New Algorithm. AAAI-92 Proceedings.

Kononenko, Igor et al. Overcoming the myopia of inductive learning algorithms
with RELIEFF (1997), Applied Intelligence, 7(1), p39-55.
}
\seealso{
Other filter: 
\code{\link{filterFeatures}()},
\code{\link{generateFilterValuesData}()},
\code{\link{getFilteredFeatures}()},
\code{\link{listFilterEnsembleMethods}()},
\code{\link{listFilterMethods}()},
\code{\link{makeFilterEnsemble}()},
\code{\link{makeFilterWrapper}()},
\code{\link{plotFilterValues}()}
}
\concept{filter}
