% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutate_variables.R
\name{mutate_variables}
\alias{mutate_variables}
\alias{mutate_variables.draws_matrix}
\alias{mutate_variables.draws_array}
\alias{mutate_variables.draws_df}
\alias{mutate_variables.draws_list}
\alias{mutate_variables.draws_rvars}
\title{Mutate variables in \code{draws} objects}
\usage{
mutate_variables(.x, ...)

\method{mutate_variables}{draws_matrix}(.x, ...)

\method{mutate_variables}{draws_array}(.x, ...)

\method{mutate_variables}{draws_df}(.x, ...)

\method{mutate_variables}{draws_list}(.x, ...)

\method{mutate_variables}{draws_rvars}(.x, ...)
}
\arguments{
\item{.x}{(draws) A \code{\link{draws}} object.}

\item{...}{Name-value pairs of expressions, each with either length 1 or the
same length as in the entire input (i.e., number of iterations or draws).
The name of each argument will be the name of a new variable, and the value
will be its corresponding value. Use a \code{NULL} value in \code{mutate_variables}
to drop a variable. New variables overwrite existing variables of the same
name.}
}
\value{
Returns a \code{\link{draws}} object of the same format as \code{.x}, with variables mutated
according to the expressions provided in \code{...}.
}
\description{
Mutate variables in a \code{\link{draws}} object.
}
\details{
In order to mutate variables in \code{\link{draws_matrix}} and \code{\link{draws_array}} objects,
they are transformed to \code{\link{draws_df}} objects first and then transformed back
after mutation. As those transformations are quite expensive for larger
number of draws, we recommend using \code{mutate_variables} on \code{\link{draws_df}} and
\code{\link{draws_list}} objects if speed is an issue.

In \code{\link{draws_rvars}} objects, the output of each expression in \code{...} is
coerced to an \code{\link{rvar}} object if it is not already one using \code{as_rvar()}.
}
\examples{
x <- as_draws_df(example_draws())
x <- subset(x, variable = c("mu", "tau"))

mutate_variables(x, tau2 = tau^2)
mutate_variables(x, scale = 1.96 * tau, lower = mu - scale)

}
\seealso{
\code{\link{variables}}, \code{\link{rename_variables}}
}
