% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvar-.R
\name{match}
\alias{match}
\alias{match.default}
\alias{match.rvar}
\alias{\%in\%}
\title{Value Matching}
\usage{
match(x, table, ...)

\method{match}{default}(x, ...)

\method{match}{rvar}(x, ...)

x \%in\% table
}
\arguments{
\item{x}{(multiple options) the values to be matched. Can be:
\itemize{
\item A base vector: see \code{\link[base:match]{base::match()}}
\item An \link{rvar}
}}

\item{table}{(vector) the values to be matched against.}

\item{...}{
  Arguments passed on to \code{\link[base:match]{base::match}}
  \describe{
    \item{\code{nomatch}}{the value to be returned in the case when no match is
    found.  Note that it is coerced to \code{integer}.}
    \item{\code{incomparables}}{a vector of values that cannot be matched.  Any
    value in \code{x} matching a value in this vector is assigned the
    \code{nomatch} value.  For historical reasons, \code{FALSE} is
    equivalent to \code{NULL}.}
  }}
}
\value{
When \code{x} is a base vector, a vector of the same length as \code{x}.

When \code{x} is an \link{rvar}, an \link{rvar} the same shape as \code{x}.
}
\description{
Generic version of \code{\link[base:match]{base::match()}}. For base vectors, returns a vector of the
positions of (first) matches of its first argument in its second. For \link{rvar}s,
returns an \link{rvar} of the matches.
}
\details{
For more information on how match behaves with base vectors, see \code{\link[base:match]{base::match()}}.

When \code{x} is an \link{rvar}, the draws of \code{x} are matched against \code{table} using
\code{\link[base:match]{base::match()}}, and the result is returned as an \link{rvar}.

The implementation of \code{\%in\%} here is identical to \code{base::\%in\%}, except
it uses the generic version of \code{match()} so that non-base vectors (such
as \link{rvar}s) are supported.
}
\examples{
x <- rvar(c("a","b","b","c","d"))
x \%in\% c("b","d")

# for additional examples, see base::match()
}
