% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{stats}
\alias{stats}
\alias{n_missing}
\alias{n_complete}
\alias{complete_rate}
\alias{n_whitespace}
\alias{sorted_count}
\alias{top_counts}
\alias{inline_hist}
\alias{n_empty}
\alias{min_char}
\alias{max_char}
\alias{n_unique}
\alias{ts_start}
\alias{ts_end}
\alias{inline_linegraph}
\alias{list_lengths_min}
\alias{list_lengths_median}
\alias{list_lengths_max}
\alias{list_min_length}
\alias{list_max_length}
\title{Summary statistic functions}
\usage{
n_missing(x)

n_complete(x)

complete_rate(x)

n_whitespace(x)

sorted_count(x)

top_counts(x, max_char = 3, max_levels = 4)

inline_hist(x, n_bins = 8)

n_empty(x)

min_char(x)

max_char(x)

n_unique(x)

ts_start(x)

ts_end(x)

inline_linegraph(x, length.out = 16)

list_lengths_min(x)

list_lengths_median(x)

list_lengths_max(x)

list_min_length(x)

list_max_length(x)
}
\arguments{
\item{x}{A vector}

\item{max_char}{In \code{top} = 3, max_levels = 4}

\item{max_levels}{The maximum number of levels to be displayed.}

\item{n_bins}{In \code{inline_hist}, the number of histogram bars.}

\item{length.out}{In \code{inline_linegraph}, the length of the character time
series.}
}
\description{
\code{skimr} provides extensions to a variety of functions with R's stats package
to simplify creating summaries of data. All functions are vectorized over the
first argument. Additional arguments should be set in the \code{\link[=sfl]{sfl()}} that sets
the appropriate skimmers for a data type. You can use these, along with other
vectorized R functions, for creating custom sets of summary functions for
a given data type.
}
\section{Functions}{
\itemize{
\item \code{n_missing()}: Calculate the sum of \code{NA} and \code{NULL} (i.e. missing) values.

\item \code{n_complete()}: Calculate the sum of not \code{NA} and \code{NULL} (i.e. missing)
values.

\item \code{complete_rate()}: Calculate complete values; complete values are not missing.

\item \code{n_whitespace()}: Calculate the number of rows containing only whitespace
values using s+ regex.

\item \code{sorted_count()}: Create a contingency table and arrange its levels in
descending order. In case of ties, the ordering of results is alphabetical
and depends upon the locale. \code{NA} is treated as a ordinary value for
sorting.

\item \code{top_counts()}: Compute and collapse a contingency table into a single
character scalar. Wraps \code{\link[=sorted_count]{sorted_count()}}.

\item \code{inline_hist()}: Generate inline histogram for numeric variables. The
character length of the histogram is controlled by the formatting options
for character vectors.

\item \code{n_empty()}: Calculate the number of blank values in a character vector.
A "blank" is equal to "".

\item \code{min_char()}: Calculate the minimum number of characters within a
character vector.

\item \code{max_char()}: Calculate the maximum number of characters within a
character vector.

\item \code{n_unique()}: Calculate the number of unique elements but remove \code{NA}.

\item \code{ts_start()}: Get the start for a time series without the frequency.

\item \code{ts_end()}: Get the finish for a time series without the frequency.

\item \code{inline_linegraph()}: Generate inline line graph for time series variables. The
character length of the line graph is controlled by the formatting options
for character vectors.
Based on the function in the pillar package.

\item \code{list_lengths_min()}: Get the length of the shortest list in a vector of lists.

\item \code{list_lengths_median()}: Get the median length of the lists.

\item \code{list_lengths_max()}: Get the maximum length of the lists.

\item \code{list_min_length()}: Get the length of the shortest list in a vector of lists.

\item \code{list_max_length()}: Get the length of the longest list in a vector of lists.

}}
\seealso{
\code{\link[=get_skimmers]{get_skimmers()}} for customizing the functions called by \code{\link[=skim]{skim()}}.
}
