% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base64.R
\name{mime_type}
\alias{mime_type}
\title{Get the MIME types of files}
\usage{
mime_type(x, use_mime = loadable("mime"), empty = "text/plain")
}
\arguments{
\item{x}{A vector of file paths.}

\item{use_mime}{Whether to use the \pkg{mime} package.}

\item{empty}{The MIME type for files without extensions (e.g., \code{Makefile}).
If \code{NA}, the type will be obtained from system command. This argument is
used only for \code{use_mime = FALSE}.}
}
\value{
A character vector of MIME types.
}
\description{
If the \pkg{mime} package is installed, call \code{\link[mime:guess_type]{mime::guess_type()}}, otherwise
use the system command \code{file --mime-type} to obtain the MIME type of a file.
Typically, the \code{file} command exists on *nix. On Windows, the command should
exist if Cygwin or Rtools is installed. If it is not found, .NET's
\code{MimeMapping} class will be used instead (which requires the .NET framework).
}
\note{
When querying the MIME type via the system command, the result will be
cached to \code{xfun:::cache_dir()}. This will make future queries much faster,
since running the command in real time can be a little slow.
}
\examples{\dontshow{if (tolower(Sys.getenv('CI')) == 'true') (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
f = list.files(R.home("doc"), full.names = TRUE)
mime_type(f)
mime_type(f, FALSE)  # don't use mime
mime_type(f, FALSE, NA)  # run command for files without extension
\dontshow{\}) # examplesIf}
}
