#! /bin/sh

TMP_DIR="${TMPDIR}"

test -z "${BIN_DIR}" && BIN_DIR=website/cgi-bin

SCRIPT_BASE=`basename $0 | sed "s/_[0-9]*\.sh$//"`

BASENAME=$(basename $0 .pl)

#BEGIN DEPEND------------------------------------------------------------------

INPUT_SCRIPT="${BIN_DIR}/${SCRIPT_BASE}"

#END DEPEND--------------------------------------------------------------------

set -ue
## set -x

test -z "${TMP_DIR}" && TMP_DIR="/tmp"
TMP_DIR="${TMP_DIR}/tmp-${BASENAME}-$$"
mkdir "${TMP_DIR}"

# To make the trap portable between bash and dash, we need to trap
# "signal" 0 ("EXIT") and rely on it for the cleanup:
## trap "rm -rf '${TMP_DIR}'" 0 1 2 3 15
trap "rm -rf '${TMP_DIR}'" EXIT
trap "exit 1" HUP INT QUIT TERM

TMP_DB_MAIN="${TMP_DIR}/db/test4fk.db"
TMP_DB_META="${TMP_DIR}/db/restful.db"

mkdir $(dirname ${TMP_DB_MAIN})
cp db/test4fk.db ${TMP_DB_MAIN}

ln -s $(pwd)/lib ${TMP_DIR}
ln -s $(pwd)/sql ${TMP_DIR}

mkdir ${TMP_DIR}/website
mkdir ${TMP_DIR}/website/cgi-bin

cp ${INPUT_SCRIPT} ${TMP_DIR}/website/cgi-bin

mkdir -p ${TMP_DIR}/${BIN_DIR}

cp ${INPUT_SCRIPT} ${TMP_DIR}/${BIN_DIR}

# Change dir to the sandbox and run the test:

cd ${TMP_DIR}

sqlite3 ${TMP_DB_META} < sql/metatables.sql
sqlite3 ${TMP_DB_META} "insert into description (id, dbname, dbtable, dbcolumn, coltype) values (1, '${TMP_DB_MAIN}', 'sample', 'id', 'id')"
sqlite3 ${TMP_DB_META} "insert into description (id, dbname, dbtable, dbcolumn, coltype, fk_target, relation, visualisation) values (2, '${TMP_DB_MAIN}', 'experiment', 'sample_id', 'fk', 1, '1', 'card')"

export REQUEST_URI="/~saulius/restful/website/test4fk.db/sample"
export HTTP_HOST=test.domain.net
export REQUEST_METHOD=post
export REMOTE_USER=writer

${INPUT_SCRIPT} \
    action=template \
    | perl -lpe 's/(tmpnewpl)[^\.]+/$1/g'

# Change back to the original directory before deleting the TMP_DIR:
cd - > /dev/null

# TMP_DIR directory will be deleted by the trap.
