#! /bin/sh

# Test representation of a table with URLs

TMP_DIR="${TMPDIR}"

test -z "${BIN_DIR}" && BIN_DIR=website/cgi-bin

SCRIPT_BASE=`basename $0 | sed "s/_[0-9]*\.sh$//"`

BASENAME=$(basename $0 .pl)

#BEGIN DEPEND------------------------------------------------------------------

INPUT_SCRIPT="${BIN_DIR}/${SCRIPT_BASE}"

#END DEPEND--------------------------------------------------------------------

set -ue
## set -x

test -z "${TMP_DIR}" && TMP_DIR="/tmp"
TMP_DIR="${TMP_DIR}/tmp-${BASENAME}-$$"
mkdir "${TMP_DIR}"

# To make the trap portable between bash and dash, we need to trap
# "signal" 0 ("EXIT") and rely on it for the cleanup:
## trap "rm -rf '${TMP_DIR}'" 0 1 2 3 15
trap "rm -rf '${TMP_DIR}'" EXIT
trap "exit 1" HUP INT QUIT TERM

# Set up the testing "sandbox":
SRC_DB_DIR=db
TMP_DB_DIR=${TMP_DIR}/db
mkdir ${TMP_DB_DIR}

TMP_TEST_DB=samples.db
TMP_DB_FILE=${TMP_DB_DIR}/samples.db
TMP_DB_META=${TMP_DB_DIR}/restful.db
TMP_DB_FILE_ABS=$(cd $(dirname ${TMP_DB_FILE}); pwd)/${TMP_TEST_DB}

mkdir ${TMP_DIR}/website
mkdir ${TMP_DIR}/website/cgi-bin
mkdir ${TMP_DIR}/tests

cp ${INPUT_SCRIPT} ${TMP_DIR}/website/cgi-bin

ln -s $(pwd)/lib ${TMP_DIR}
ln -s $(pwd)/sql ${TMP_DIR}
ln -s $(pwd)/tests/inputs ${TMP_DIR}/tests

mkdir -p ${TMP_DIR}/${BIN_DIR}

cp ${INPUT_SCRIPT} ${TMP_DIR}/${BIN_DIR}

# Change dir to the sandbox and run the test:

cd ${TMP_DIR}

sqlite3 ${TMP_DB_FILE} < tests/inputs/samples-r92.sql
sqlite3 ${TMP_DB_FILE} <<END
    create table related_samples (
        id int(11) NOT NULL,
        sample_id1 int(11) DEFAULT NULL,
        sample_id2 int(11) DEFAULT NULL);
END
sqlite3 ${TMP_DB_FILE} <<END
    create view 'homepage' as
    select 's1'.'id' AS 'id', 's1'.'SolsaID' AS 'SolsaID', 's1'.'name' AS 'Rock_name',
        'origin'.'location' AS 'Origin_country', 'origin'.'mine' AS 'Origin_site_mine'
     from (((('sample' 's1' left join 'related_samples' on(('s1'.'id' = 'related_samples'.'sample_id1')))
                            left join 'sample' 's2' on(('s2'.'id' = 'related_samples'.'sample_id2')))
                            left join 'natural_sample' on(('natural_sample'.'sample_id' = 's1'.'id')))
                            left join 'origin' on(('natural_sample'.'origin_id' = 'origin'.'id'))) group by 's1'.'id';
END
sqlite3 ${TMP_DB_FILE} "insert into sample (id, uuid, SolsaID) values (1, '55bb4b09-8daa-478e-8ad5-ddf20ac58bf3', 'VU-TEST-0001')"

sqlite3 ${TMP_DB_META} < sql/metatables.sql
sqlite3 ${TMP_DB_META} < tests/inputs/samples-metadata-r92.sql
sqlite3 ${TMP_DB_META} <<END
    insert into description (id, dbtable, dbcolumn, coltype, fk_target, relation)
        values (134, "related_samples", "sample_id1", "fk", 1, 1);
    insert into description (id, dbtable, dbcolumn, coltype, fk_target, relation)
        values (135, "related_samples", "sample_id2", "fk", 1, 1);
END
sqlite3 ${TMP_DB_META} "update description set dbname = '${TMP_DB_FILE_ABS}'"

export REQUEST_URI='/~saulius/restful/website/samples.db/homepage'
export HTTP_HOST=test.domain.net
export REQUEST_METHOD=POST
export QUERY_STRING=""
export REMOTE_USER=tester

(
${INPUT_SCRIPT} \
    column%3Ahomepage%3A0.id=1 \
    column%3Ahomepage%3A0.SolsaID=VU-TEST-0001 \
    column%3Ahomepage%3A0.Rock_name=topaz \
    Save=Save
sqlite3 -echo -nullvalue NULL ${TMP_DB_FILE} "select * from sample"
sqlite3 -echo -nullvalue NULL ${TMP_DB_FILE} "select * from related_samples"
sqlite3 -echo -nullvalue NULL ${TMP_DB_FILE} "select * from natural_sample"
sqlite3 -echo -nullvalue NULL ${TMP_DB_FILE} "select * from origin"
sqlite3 -echo -nullvalue NULL ${TMP_DB_FILE} "select * from homepage"
)

# Go back to the original directory before deleting the temporary one:
cd - > /dev/null

# Temporary directory will be deleted by the trap.
