---
myst:
  html_meta:
    keywords: LaTeX, fichiers, tds, installation, installer un package LaTeX, 
              installer une extension LaTeX
---

# Comment installer des extensions sous forme de fichiers ZIP ?

L'installation d'extensions, telles qu'elles apparaissent "traditionnellement" 
sur [CTAN](/1_generalites/documentation/le_catalogue_du_ctan), implique : 

- d'identifier où placer les différents fichiers sur une arborescence [TDS](la_tds) ;
- de les installer ; 
- et de faire un peu de maintenance.

La plupart des gens, pour la plupart des extensions, trouvent les deux premières étapes coûteuses, 
la dernière étant vue comme bien plus facile (à moins qu'elle ne soit oubliée !).

Les fichiers ZIP prêts à l'emploi --- également connus 
sous le nom de [fichiers TDS-ZIP](installer_a_partir_d_un_fichier_zip2) ---
sont conçus pour alléger la charge des deux premières étapes de l'installation : 
ils contiennent tous les fichiers qui doivent être installés pour une extension donnée, 
à leur emplacement "correct" dans l'arborescence [TDS](la_tds).

Pour installer un tel fichier sur un système Unix 
(en supposant que vous installerez dans l'arbre TEXMF local, à `$TEXMFLOCAL`) :

```bash
cd $TEXMFLOCAL
unzip $extension.tds.zip
```

Sur un système Windows disposant d'un décompresseur ZIP intégré, 
il suffit de double-cliquer sur le fichier et de naviguer jusqu'à l'endroit 
où il doit être décompressé. Ceux qui utilisent des versions plus anciennes de Windows 
ont probablement déjà l'expérience de l'utilisation de `WinZIP` ou d'un outil similaire.

Après avoir décompressé l'archive `zip`, dans la plupart des cas, 
la seule tâche restante est de mettre à jour les index des fichiers --- 
comme expliquer dans la question "[](installer_des_fichiers_pour_latex)".
Cependant, si l'extension fournit une police, 
vous devez également activer le fichier de correspondance de la police, 
ce qui est évoqué dans la question 
"[](/5_fichiers/formats/fontes/installation_de_fontes/installer_une_police_t1)".

:::{sources}
[Installing using ready-built ZIP files](faquk:FAQ-inst-tds-zip)
:::